import numpy as np

# Undersample input image (im) in the k-space domain by factors of Rx and Ry
def undersample(im, Rx, Ry): 
    Nc, Ny, Nx = im.shape 

    # Generate mask in kx direction
    kx = np.zeros(Nx)
    kx[::Rx] = 1

    # Generate mask in ky direction
    ky = np.zeros(Ny)
    ky[::Ry] = 1

    # Apply masks to image k-space
    ima = np.zeros_like(im) 
    for n in range(Nc):
        m = np.fft.fft2(im[n, :, :]) 

        m *= kx
        m *= ky[:, np.newaxis]
        ima[n, :, :] = np.fft.ifft2(m)
    return ima

# Combine coil images using sum of squares
def ss_combine(im):
    im_ss = np.zeros((im.shape[1], im.shape[2]), dtype=complex)
    for m in range(im.shape[1]):
        for n in range(im.shape[2]):
            reshaped = im[:, m, n].reshape(8, -1)
            im_ss[m, n] = np.sqrt(np.sum(reshaped * reshaped))
    return im_ss